#ifndef TTEXTURE_H__
#define TTEXTURE_H__

enum
{
	TEXTURETAG_OFFSETX							= 1000, // REAL
	TEXTURETAG_OFFSETY							= 1001, // REAL
	TEXTURETAG_LENGTHX							= 1002, // REAL
	TEXTURETAG_LENGTHY							= 1003, // REAL
	TEXTURETAG_PROJECTION						= 1004, // LONG
		TEXTURETAG_PROJECTION_SPHERICAL		= 0,
		TEXTURETAG_PROJECTION_CYLINDRICAL = 1,
		TEXTURETAG_PROJECTION_FLAT        = 2,
		TEXTURETAG_PROJECTION_CUBIC       = 3,
		TEXTURETAG_PROJECTION_FRONTAL     = 4,
		TEXTURETAG_PROJECTION_SPATIAL     = 5,
		TEXTURETAG_PROJECTION_UVW         = 6,
		TEXTURETAG_PROJECTION_SHRINKWRAP  = 7,
		TEXTURETAG_PROJECTION_CAMERAMAP		= 8,
	TEXTURETAG_SIDE									= 1005, // LONG
		TEXTURETAG_SIDE_FRONTANDBACK			= 0,
		TEXTURETAG_SIDE_FRONT							= 1,
		TEXTURETAG_SIDE_BACK							= 2,
	TEXTURETAG_RESTRICTION					= 1006, // STRING
	TEXTURETAG_TILE									= 1007, // BOOL
	TEXTURETAG_SEAMLESS							= 1008, // BOOL
	TEXTURETAG_MIX									= 1009, // BOOL

	TEXTURETAG_MATERIAL							= 1010, // link

	TEXTURETAG_POSITION							= 1011,	// vector
	TEXTURETAG_SIZE									= 1012,	// vector
	TEXTURETAG_ROTATION							= 1013,	// vector

	TEXTURETAG_TILESX								= 1014, // virtual ID
	TEXTURETAG_TILESY								= 1015, // virtual ID

	TEXTURETAG_STOPINTERACTIVEMAPPING = 1016,

	TEXTURETAG_CAMERA									= 1017, // link
	TEXTURETAG_CAMERA_FILMASPECT			= 1018, // REAL
	TEXTURETAG_CAMERA_PIXELASPECT			= 1020, // REAL

	TEXTURETAG_CAMERA_CALCULATE				= 1101, // button

	TEXTURETAG_UVBUMP									= 1200,
	TEXTURETAG_REPETITIONX						= 1201,
	TEXTURETAG_REPETITIONY						= 1202,

	TEXTURETAG_COORDINATEGROUP 				= 840,	// group

	// the following (virtual) IDs MUST be kept in sync with Drendersettings.h
	TEXTURETAG_CAMERA_FILMPRESET			= 10000,
		TEXTURETAG_CAMERA_FILMPRESET_CUSTOM								= 0,
		TEXTURETAG_CAMERA_FILMPRESET_SQUARE								= 1, // 1:1
		TEXTURETAG_CAMERA_FILMPRESET_STANDARD							= 2, // 4:3
		TEXTURETAG_CAMERA_FILMPRESET_HDTV             		= 3, // 16:9
		TEXTURETAG_CAMERA_FILMPRESET_35MMSTILL        		= 4, // 3:2
		TEXTURETAG_CAMERA_FILMPRESET_WIDESCREEN       		= 5, // 14:9
		TEXTURETAG_CAMERA_FILMPRESET_35MM             		= 6, // 1.85:1
		TEXTURETAG_CAMERA_FILMPRESET_PANAVISION       		= 7, // 2.39:1

	TEXTURETAG_CAMERA_PIXELPRESET			= 10001,
		TEXTURETAG_CAMERA_PIXELPRESET_CUSTOM							= 0,
		TEXTURETAG_CAMERA_PIXELPRESET_SQUARE							= 1,
		TEXTURETAG_CAMERA_PIXELPRESET_D1DVNTSC						= 2,
		TEXTURETAG_CAMERA_PIXELPRESET_D1DVPAL							= 3,
		TEXTURETAG_CAMERA_PIXELPRESET_D1DVNTSCWIDESCREEN	= 4,
		TEXTURETAG_CAMERA_PIXELPRESET_HDVANAMORPHIC				= 5,
		TEXTURETAG_CAMERA_PIXELPRESET_D1DVPALWIDESCREEN		= 6,
		TEXTURETAG_CAMERA_PIXELPRESET_ANAMORPHIC					= 7,
};

#endif	// TTEXTURE_H__

